/*
 * Decompiled with CFR 0.152.
 */
package com.sf;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.ArrayList;
import java.util.List;

public class S3ListObjects {
    private static final AmazonS3 s3Client = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(Regions.US_WEST_2)).build();

    public static List<String> listS3BucketContents(String bucketName, String prefix) {
        ArrayList<String> objects = new ArrayList<String>();
        try {
            ListObjectsV2Request req = new ListObjectsV2Request().withBucketName(bucketName).withPrefix(prefix);
            ListObjectsV2Result result = s3Client.listObjectsV2(req);
            if (!result.getObjectSummaries().isEmpty()) {
                System.out.println("Files in bucket '" + bucketName + "':");
                for (S3ObjectSummary objectSummary : result.getObjectSummaries()) {
                    System.out.println("- " + objectSummary.getKey() + " (Size: " + objectSummary.getSize() + " bytes)");
                    objects.add(objectSummary.getKey());
                }
            } else {
                System.out.println("No objects found with prefix '" + prefix + "'");
            }
        }
        catch (Exception e) {
            System.out.println("Error accessing S3 bucket: " + e.getMessage());
        }
        return objects;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java S3ListObjects <bucket_name> <prefix>");
            System.exit(1);
        }
        String bucketName = args[0];
        String prefixFilePath = args[1];
        List<String> s3Objects = S3ListObjects.listS3BucketContents(bucketName, prefixFilePath);
        System.out.println("Found " + s3Objects.size() + " objects to process");
    }
}

